<?php
/**
  * pentode rest-api
  * suitable for personal or community use
  * 2020 Andreas Bahr 
  * GPL3 - see license.txt
  */


include "start.php";
$sysconfig = new systemConfig();

// request & filter params
$cmd = "ERROR";
switch($_GET['cmd']) {
	case 'LIST':
	case 'TUNE':
	case 'INFO-PARAMS':
	case 'EDITOR-LINK':
		if($sysconfig->get_RADIO_ACTIVE()) $cmd = $_GET['cmd'];
		break;
}
$id = $_GET['id'] != '' ? (int)$_GET['id'] : 0;
$clienttype = str_replace(array("\'", "\"", "<") , '' , $_GET['clienttype']);
$mimetype = str_replace(array("\'", "\"", "<") , '' , $_GET['mimetype']);

// do job
$data = array();
$wrs = new webRadioCatalog();
switch($cmd) {
	case 'LIST':
		$data['station'] = $wrs->stationList2($mimetype, $clienttype);
		$data['cmd'] = 'OK';
		break;
	case 'TUNE':
		$data['station'] = $wrs->tuneStation($id, $mimetype, $clienttype, true);
		$data['cmd'] = 'OK';
		break;
	case 'INFO-PARAMS':
		$swinfo = array(
			'system' => 'pentode-connector v1',
			'signature' => $sysconfig->get_SYSTEM_SIGNATURE(),
			'echoClientType' => $clienttype,
			'echoMimeType' => $mimetype
		);
		$data['info'] = $swinfo;
		$data['cmd'] = 'OK';
		break;
	case 'EDITOR-LINK':
		$editorLink = "";
		if($sysconfig->get_EDITOR_ACTIVE()) $editorLink = $sysconfig->get_EDITOR_URL();
		$data['linkUrl'] = $editorLink;
		$data['cmd'] = 'OK';
		break;
	default:
		$data['cmd'] = 'ERROR';
}

// send response
header('Content-Type: application/json');
echo json_encode($data);
?>
