<?php
/**
  * mysql-improved api
  * drop-in replacement for mysqlapi.class.php
  * 2020 Andreas Bahr 
  */


class mysqliapi {

	//private $dbcharset = "utf8";
	public $dbconn = null;
	
	// connect to db
	function __construct() {
		$sysconfig = new systemConfig();
		$this->dbconn = new mysqli($sysconfig->get_DB_HOST_URL(), $sysconfig->get_DB_USERNAME(), $sysconfig->get_DB_PASSWORD(), $sysconfig->get_DB_NAME()); 
	}

	// returns a query-result as an array
	function query($sql) {
		$res = array();
		$query = $this->dbconn->query($sql); 
		if($query->num_rows > 0) while($row = $query->fetch_assoc()) $res[] = $row;
		return $res;
	}
	
	// executes a query with no result-set
	function execute($sql) {
		$query = $this->dbconn->query($sql); 
		return mysqli_affected_rows($this->dbconn);			
	}
	
	// avoid sql-injection
	function escape($string) {
		return stripslashes(mysqli_real_escape_string($this->dbconn, $string));
	}
	
	//lookup single value
	function lookup ($field, $table, $where = "") { 
		$lresult = "";
		$res = $this->dbconn->prepare('SELECT ? FROM ? WHERE ? ORDER BY ?');
		$res->execute(array($field, $table, $where, $field));
		if(!($this->dbconn->errno) AND mysqli_num_rows($res) > 0) $lresult = $res->fetchColumn();
		return $lresult;
	}

	// returns the last inserted id
	function insertId () { 
		$lresult = "";
		$res = $this->dbconn->query("SELECT LAST_INSERT_ID() AS LRESULT");
		if(!($this->dbconn->errno) AND $res->num_rows > 0) $lresult = $res->fetch_assoc();
		return $lresult['LRESULT'];
	}
}
?>
