<?php
/**
  * system configuration
  * 2020 Andreas Bahr 
  */


class systemConfig {

	// the config-file as seen from /system
	private $CONFIG_FILE = "../config/pentode-config.txt.php";

	// hard wired defaults
	private $DB_HOST_URL = 'localhost';
	private $DB_NAME = '';
	private $DB_USERNAME = '';
	private $DB_PASSWORD = '';
	private $RADIO_ACTIVE = true;
	private $EDITOR_ACTIVE = false;
	private $EDITOR_URL = "";
	private $SYSTEM_SIGNATURE = "";
		
	function __construct() {
		$offset = 6;
		$lines = array();
		$line = '';
		$lineNr = 0;

		if(file_exists($this->CONFIG_FILE)) {
			$lines = file($this->CONFIG_FILE, FILE_IGNORE_NEW_LINES);
			foreach ($lines as $lineNr => $line) {
				$logiLine = $lineNr - $offset;
				switch($logiLine) {
					case 0:
						$this->DB_HOST_URL = $line;
						break;
					case 1:
						$this->DB_NAME = $line;
						break;
					case 2:
						$this->DB_USERNAME = $line;
						break;
					case 3:
						$this->DB_PASSWORD = $line;
						break;
					case 4:
						if($line == "true") $this->RADIO_ACTIVE = true;
						else if($line == "false") $this->RADIO_ACTIVE = false;
						break;
					case 5:
						if($line == "true") $this->EDITOR_ACTIVE = true;
						else if($line == "false") $this->EDITOR_ACTIVE = false;
						break;
					case 6:
						$this->EDITOR_URL = $line;
						break;
					case 7:
						$this->SYSTEM_SIGNATURE = $line;
						break;
				}
			}
		}
	}
	
	function get_DB_HOST_URL() {
		return $this->DB_HOST_URL;
	}
	
	function get_DB_NAME() {
		return $this->DB_NAME;
	}
	
	function get_DB_USERNAME() {
		return $this->DB_USERNAME;
	}
	
	function get_DB_PASSWORD() {
		return $this->DB_PASSWORD;
	}

	function get_RADIO_ACTIVE() {
		return $this->RADIO_ACTIVE;
	}
	
	function get_EDITOR_ACTIVE() {
		return $this->EDITOR_ACTIVE;
	}

	function get_EDITOR_URL() {
		return $this->EDITOR_URL;
	}

	function get_SYSTEM_SIGNATURE() {
		return $this->SYSTEM_SIGNATURE;
	}
}
?>
