/**
  * pentode's JS toolbox
  * 2020 Andreas Bahr
  */

/** show station list */
function showStationList() {
	$("#stationList").show();
	$("#showStations").addClass("active");
	$("#streamList").hide();
	$("#showStreams").removeClass("active");
}

/** show stream list */
function showStreamList() {
	$("#stationList").hide();
	$("#showStations").removeClass("active");
	$("#streamList").show();
	$("#showStreams").addClass("active");
}

/** sleep-timer */
var sweetDream = {
	oneMinute: 60000,
	timerHandle: 0,
	downCounterMinutes: 0,
	lastTickTS: 0,

	start: function(minutes) {
		sweetDream.downCounterMinutes = parseFloat(minutes);
		sweetDream.lastTickTS = Date.now();
		sweetDream.showStatus();
		$("#cancelTimer").removeClass("disabled");
		sweetDream.timerHandle = window.setInterval(sweetDream.ticks, sweetDream.oneMinute);
	},

	cancel: function() {
		clearInterval(sweetDream.timerHandle);
		$("#cancelTimer").addClass("disabled");
		sweetDream.resetGui();
	},

	ticks: function() {
		nowTS = Date.now();
		
		sweetDream.downCounterMinutes = sweetDream.downCounterMinutes - ((nowTS - sweetDream.lastTickTS) / sweetDream.oneMinute);
		sweetDream.lastTickTS = nowTS;
		sweetDream.showStatus();
		if(sweetDream.downCounterMinutes <= 0) {sweetDream.fire();}
	},

	fire: function() {
		rauDio.resetAudio();
		rauGui.setStation("");
		rauGui.setStream("");
		rauGui.showStatus("");
		sweetDream.cancel();
	},

	showStatus: function() {
		$("#timerDisplay").html("Time left: " + Math.round(sweetDream.downCounterMinutes).toString() + " minutes");
	},

	resetGui: function() {
		$("#timerDisplay").html("&nbsp;");
	},
}
