<?php
/**
  * pentode Webradio Catalog Editor
  * 2020 Andreas Bahr 
  * GPL3 - see license.txt
  */


include 'system/start-editor.php';

$ctrl = new controller();
$ctrl->main();

// html template
?><!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<title>pentode Webradio Catalog Editor</title>
	<meta name="author" content="2020 Andreas Bahr">
	<meta name="robots" content="noindex,nofollow">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<link href="css/bootstrap.min.css" rel="stylesheet" media="screen">
	<link href="radio-catalog.css" rel="stylesheet" media="screen">
</head>

<body>
	<div class="container">
		<div class="row">
			<div class="col-sm-5">
				<h2>pentode</h2>
				<a href="javascript:action0();"><h4>Webradio Catalog</h4></a>
				<div style="margin-top: 20px;"><?= $ctrl->responseTuner() ?></div>
				<div id="audioCapsDisplay" style="margin-top: 20px; width: 250px;"><a href="javascript:action99();">Show Audio Capabilities</a></div>
				<div style="margin-top: 20px;"><?php if($ctrl->responseRadioLink() != '') echo('<a href="'.$ctrl->responseRadioLink().'" target="pentode-webradio"><span class="lead">pentode Radio</span></a>'); ?></div>
			</div>

			<div class="col-sm-7">
				<!-- dynamic content area -->
				<?= $ctrl->responseContent() ?>
			</div>
		</div>
	</div>
	
	<div class="container">
		<footer id="theFooter" class="info">pentode Webradio Catalog Editor v1 - 2020 Andreas Bahr</footer>
	</div>

	<script src="js/dev-jquery-1.10.2.js"></script>
	<script src="js/bootstrap.min.js"></script>
	<!-- link rel="shortcut icon" href="favicon.ico" / -->
	<!-- IE8 support -->
	<!--[if lt IE 9]>
		<script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
		<script src="https://oss.maxcdn.com/libs/respond.js/1.4.2/respond.min.js"></script>
	<![endif]-->
	<script src="toolbox-editor.js"></script>
</body>
</html>
