<?php
/**
  * the editor's controller
  * 2020 Andreas Bahr 
  */


class controller {
	
	private $cmd = '';
	private $id = '';
	private $stationId = '';
	private $fileName = '';
	private $errMSG = '';
	
	private $sysconfig = null;
	
	private $htmlTuner = '';
	private $htmlContent = '';
	
	function __construct() {
		$this->sysconfig = new systemConfig();
	}

	function requestParams() {
		$arrValid = array('LIST', 'SHOW', 'NEW', 'EDIT', 'SAVE', 'DELETE', 'NEW-STREAM', 'EDIT-STREAM', 'SAVE-STREAM', 'DELETE-STREAM', 'LIST-LOGO', 'CHOOSE-LOGO', 'UPLOAD', 'USERFILE');
		if(in_array($this->http_param('CMD'), $arrValid)) $this->cmd = $this->http_param('CMD');
		else $this->cmd = 'LIST';

		$this->id = $this->http_param('ID', 0);
		$this->stationId = $this->http_param('STATIONID', 0);
		$this->fileName = $this->http_param('FILENAME');
	}

	function main() {
		$this->requestParams();
		try {
			$this->computeMain();
			$this->generateHTML();
			$this->errorHandling();
		} catch (Exception $e) {
			$this->cmd = 'ERROR';
			$this->errMSG = $e->getMessage();
			$this->errorHandling();
		}
	}
	
	function computeMain() {
		switch($this->cmd) {
			case 'SAVE':
				$this->computeSave();
				break;
			case 'CHOOSE-LOGO':
				$this->computeChooseLogo();
				break;
			case 'USERFILE':
				$this->computeUserFile();
				break;
			case 'DELETE':
				$this->computeDelete();
				break;
			case 'SAVE-STREAM':
				$this->computeSaveStream();
				break;
			case 'DELETE-STREAM':
				$this->computeDeleteStream();
				break;
		}
	}

	function computeSave() {
		$model = new modelStation();
		$arrFields = array('name', 'longName', 'nation', 'website');
		$ret = $model->set($this->http_form_data($arrFields), $this->id);
		$this->cmd = 'SHOW';
		$this->id = $ret;
	}
	
	function computeChooseLogo() {
		$model = new modelStation();
		if($this->fileName == 'NO-LOGO-FILE') {
			// un-set
			$ret = $model->setLogo('', $this->id);
		} else {
			$ret = $model->setLogo($this->fileName, $this->id);
		}
		$this->cmd = 'SHOW';
	}

	function computeUserFile() {
		$files = new filesFolders($this->sysconfig->get_LOGO_FOLDER());
		$fileName = $files->handleUpload('USERFILE');
		if($fileName != '') {
			$model = new modelStation();
			if($model->setLogo($fileName, $this->id)) {
				$this->cmd = 'SHOW';
			} else {
				$this->cmd = 'ERROR';
				$this->errMSG = 'Database update failure';
			}
		} else {
			$this->cmd = 'ERROR';
			$this->errMSG = 'Upload failed';
		}
	}

	function computeDelete() {
		$modelStream = new modelStream();
		$modelStream->delete($this->id, 0);
		$modelStation = new modelStation();
		$modelStation->delete($this->id);
		$this->cmd = 'LIST';
	}

	function computeSaveStream() {
		$model = new modelStream();
		$arrFields = array('mimeType', 'qualityBR', 'streamUrl');
		$model->set($this->http_form_data($arrFields), $this->stationId, $this->id);
		$this->cmd = 'SHOW';
		$this->id = $this->stationId;
	}

	function computeDeleteStream() {
		$model = new modelStream();
		$model->delete($this->stationId, $this->id);
		$this->cmd = 'SHOW';
		$this->id = $this->stationId;
	}

	function generateHTML() {
		$view = new viewStation();
		switch($this->cmd) {
			case 'LIST':
				$this->htmlContent = $view->list();
				break;
			case 'SHOW':
				$this->htmlContent = $view->show($this->id);
				$view2 = new viewStream();
				$this->htmlContent .= $view2->list($this->id);
				$view3 = new viewTuner();
				$this->htmlTuner = $view3->show($this->id);
				break;
			case 'NEW':
				$this->htmlContent = $view->showEditor(0);
				break;
			case 'EDIT':
				$this->htmlContent = $view->showEditor($this->id);
				break;
			case 'NEW-STREAM':
				$view2 = new viewStream();
				$this->htmlContent = $view2->showEditor($this->id, 0);
				break;
			case 'EDIT-STREAM':
				$view2 = new viewStream();
				$this->htmlContent = $view2->showEditor(0, $this->id);
				$view3 = new viewTuner();
				$this->htmlTuner = $view3->show(0, $this->id);
				break;
			case 'LIST-LOGO':
				$view2 = new viewFile($this->sysconfig->get_LOGO_FOLDER());
				$this->htmlContent = $view2->list($this->id);
				break;
			case 'UPLOAD':
				$view2 = new viewFile($this->sysconfig->get_LOGO_FOLDER());
				$this->htmlContent = $view2->uploadFile($this->id);
				break;
		}
	}

	function errorHandling() {
		if($cmd == 'ERROR') {
			$this->htmlContent = '<p style="margin-top: 25px;"><span class="badge badge-important" style="background-color: #b94a48 !important;"><span class="glyphicon glyphicon-exclamation-sign"></span></span>&nbsp;<b>System Error';
			if($this->errMSG != '') {
				$this->htmlContent .= ': '.$this->errMSG;
			} else {
				$this->htmlContent .= ': Serious System Error';
			}
			$this->htmlContent .= '</b></p>';
		}
	}
	
	function responseTuner() {
		return $this->htmlTuner;
	}

	function responseRadioLink() {
		if($this->sysconfig->get_RADIO_ACTIVE()) return $this->sysconfig->get_RADIO_URL();
		else return '';
	}

	function responseContent() {
		return $this->htmlContent;
	}

	// read param from http-get/post
	function http_param($field, $default="") { 
		$var = $default; 
		if (isset ($_GET[$field]) && $_GET[$field] != "") $var = $_GET[$field]; 
		elseif (isset ($_POST[$field]) && $_POST[$field] != "") $var = $_POST[$field]; 
		return $var; 
	} 

	// read param from http-get/post
	function http_form_data($fields) { 
		$arrData = array();
		foreach($fields as $value) $arrData[$value] = $this->http_param($value);
		return $arrData; 
	} 
}
?>
