<?php
/**
 * files & folders
 * 2020 Andreas Bahr 
 */


class filesFolders {

	private $basePath = '';
	private $dateFormat = 'Y-m-d';
	//private $dateFormat = 'd.m.Y';
	
	function __construct($basePath = '') {
		if($basePath != '') $this->basePath = $basePath;
	}

	/* scan a folder
	 * -------------
	 * array column's:
	 * 0: f=file, d=folder
	 * 1: path
	 * 2: name
	 * 3: mime-type
	 * 4: bytes
	 * 5: last accessed date
	 * 6: last modified date
	 * 7: posix-user-name
	 * 8: posix-group-name
	 */
	function list($path = '') {
		if($path == '') $path = $this->basePath;
		$starray = array();
		$dirray = scandir($path);
		// PHP 5.3: $finfo = new finfo(FILEINFO_MIME, $mimemagicdb);
		foreach($dirray AS $file) {
			switch($file) {
				case ".":
				case "..":
					$ford = "d";
					break;
				default:
					if(is_dir($path.DIRECTORY_SEPARATOR.$file)) $ford = "d";
					else $ford = "f";
			}
			$statinfo = stat($path.DIRECTORY_SEPARATOR.$file);
			if($ford == "f") {
				$fsize = $statinfo["size"];
				$mimetype = mime_content_type($path.DIRECTORY_SEPARATOR.$file);
			} else {
				$fsize = 0;
				$mimetype = "";
			}
			$userinfo = posix_getpwuid($statinfo["uid"]);
			$groupinfo = posix_getgrgid($statinfo["gid"]);
			$atime = date($this->dateFormat, $statinfo["atime"]);
			$mtime = date($this->dateFormat, $statinfo["mtime"]);
			$starray[] = array($ford, $path, $file, $mimetype, $fsize, $atime, $mtime, $userinfo["name"], $groupinfo["name"]);
		}
		return $starray;
	}

	// navigate file path one level up
	function dir_up($dirpath) {
		if($dirpath == '/') return '';
		$dirpath = format_folderpath($dirpath);
		for($i = strlen($dirpath) - 2; $i >= 0; $i--) {
			if($dirpath[$i] == DIRECTORY_SEPARATOR) {
				$dirpath = substr($dirpath, 0, $i);
				break;
			}
		}
		//if($dirpath == '') return '/';
		return $dirpath;
	}

	// filepath string formating
	function format_folderpath($folderpath) {
		if(substr($folderpath, -1, 1) == DIRECTORY_SEPARATOR) {
			$folderpath = substr($folderpath, 0, strlen($folderpath) - 1);
		}
		return $folderpath;
	}

	// number scaling
	function nsizer($value, $ddigits = 0, $sign = "B") {

	  if($value >= 1099511627776) $ret = sprintf("%.".$ddigits."f"." T".$sign, $value / 1099511627776);
	  elseif($value >= 1073741824) $ret = sprintf("%.".$ddigits."f"." G".$sign, $value / 1073741824);
	  elseif($value >= 1048576) $ret = sprintf("%.".$ddigits."f"." M".$sign, $value / 1048576);
	  elseif($value >= 1024) $ret = sprintf("%.".$ddigits."f"." K".$sign, $value / 1024);
	  else $ret = $value." ".$sign;
	  return $ret;
	}
	
	// handle 1 file-upload
	function handleUpload($handleName) {
		$uploadFile = $this->basePath.DIRECTORY_SEPARATOR.basename($_FILES[$handleName]['name']);
		if (move_uploaded_file($_FILES[$handleName]['tmp_name'], $uploadFile)) return basename($_FILES[$handleName]['name']);
		else return '';
	}
}
?>
