<?php
/**
  * the editor's model classes
  * 2020 Andreas Bahr 
  */


/* domain: webradio station */
class modelStation {

	private $db = null;
		
	function __construct() {
		$this->db = new mysqliapi();
	}

	function list() {
		$sql = 'SELECT DISTINCT a.id, a.name, a.longName, MAX(d.name) AS langText, MAX(c.name) AS nationText, a.website, a.logoFile, COUNT(b.stationId) AS howManyStreams ';
		$sql .= 'FROM station a ';
		$sql .= 'LEFT JOIN stream b ON a.id = b.stationId ';
		$sql .= 'LEFT JOIN iso639 d ON a.lang = d.id ';
		$sql .= 'LEFT JOIN iso3166 c ON a.nation = c.id ';
		$sql .= 'GROUP BY a.id ';
		$sql .= 'ORDER BY a.name ASC';
		return $this->db->query($sql);
	}

	function get($id) {
		$sql = 'SELECT a.id, a.name, a.longName, a.nation, c.name AS nationText, a.website, a.logoFile, a.editTS ';
		$sql .= 'FROM station a ';
		$sql .= 'LEFT JOIN iso3166 c ON a.nation = c.id ';
		$sql .= 'WHERE a.id = '.$id;
		return $this->db->query($sql);
	}

	// return's the id
	function set($data, $id = 0) {
		if($id == 0) {
			// insert
			$sql = 'INSERT INTO station (';
			foreach($data as $key => $value) $sql .= $key.', ';
			$sql = substr($sql, 0, -2);
			$sql .= ') VALUES (';
			foreach($data as $value) $sql .= "'".$this->db->escape($value)."', ";
			$sql = substr($sql, 0, -2);
			$sql .= ')';
		} else {
			// update
			$sql = 'UPDATE station SET ';
			foreach($data as $key => $value) $sql .= $key." = '".$this->db->escape($value)."', ";
			$sql = substr($sql, 0, -2);
			$sql .= ' WHERE id = '.$id;
		}
		$this->db->execute($sql);
		if($id == 0) return $this->db->insertId();
		else return $id;
	}

	function setLogo($fileName, $id) {
		if($this->db->execute("UPDATE station SET logoFile = '".$fileName."' WHERE id = ".$id) == 1) return true;
		else return false;
	}

	function delete($id) {
		if($this->db->execute('DELETE FROM station WHERE id = '.$id) == 1) return true;
		else return false;
	}

	function listNations() {
		return $this->db->query('SELECT * FROM iso3166 ORDER BY name ASC');
	}
}


/* domain: webradio stream */
class modelStream {

	private $db = null;
	private $mimeTypes = array('audio/mp4', 'audio/mpeg', 'audio/ogg', 'audio/opus', 'audio/wav', 'audio/x-ms-wma', 'audio/webm');
	private $qualityBRs = array('1' => 'Best Quality, high Bitrate',
								'2' => 'Medium Quality / Bitrate',
								'3' => 'Low Quality / Bitrate'
								);
		
	function __construct() {
		$this->db = new mysqliapi();
	}

	function list($stationId) {
		return $this->db->query('SELECT * FROM stream WHERE stationId = '.$stationId.' ORDER BY mimeType, qualityBR ASC');
	}

	function get($id) {
		return $this->db->query('SELECT * FROM stream WHERE id = '.$id);
	}

	// return's true when data was updated
	function set($data, $stationId, $id = 0) {
		if($id == 0) {
			// insert
			$sql = 'INSERT INTO stream (stationId, ';
			foreach($data as $key => $value) $sql .= $key.', ';
			$sql = substr($sql, 0, -2);
			$sql .= ') VALUES ('.$stationId.', ';
			foreach($data as $key => $value) {
				switch($key) {
					case 'qualityBR';
						// integer data
						$sql .= $this->db->escape($value).', ';
						break;
					default:
						// varchar data
						$sql .= "'".$this->db->escape($value)."', ";
				}
			}
			$sql = substr($sql, 0, -2);
			$sql .= ')';
		} else {
			// update
			$sql = 'UPDATE stream SET ';
			foreach($data as $key => $value) {
				switch($key) {
					case 'qualityBR';
						// integer data
						$sql .= $key." = ".$this->db->escape($value).", ";
						break;
					default:
						// varchar data
						$sql .= $key." = '".$this->db->escape($value)."', ";
				}
			}
			$sql = substr($sql, 0, -2);
			$sql .= ' WHERE id = '.$id;
		}
		if($this->db->execute($sql) == 1) return true;
		else return false;
	}

	/* delete a single stream using $id, 
	 * or all streams given the $stationId
	 * return's true when data was deleted */
	function delete($stationId, $id = 0) {
		if($id != 0) $sql = 'DELETE FROM stream WHERE id = '.$id;
		elseif($stationId != 0) $sql = 'DELETE FROM stream WHERE stationId = '.$stationId;
		$ret = $this->db->execute($sql);
		if($ret >= 1) return true;
		else return false;
	}

	function listMimeType() {
		return $this->mimeTypes;
	}

	function listQualityBR() {
		return $this->qualityBRs;
	}
}
?>
