<?php
/**
  * system configuration
  * 2020 Andreas Bahr 
  */


class systemConfig {

	// the config-file as seen from web-root
	private $CONFIG_FILE = 'config/pentode-editor-config.txt.php';

	// hard wired defaults
	private $DB_HOST_URL = 'localhost';
	private $DB_NAME = '';
	private $DB_USERNAME = '';
	private $DB_PASSWORD = '';
	private $RADIO_ACTIVE = false;
	private $RADIO_URL = "";
	private $LOGO_FOLDER = "";
		
	function __construct() {
		$offset = 6;
		$lines = array();
		$line = '';
		$lineNr = 0;

		if(file_exists($this->CONFIG_FILE)) {
			$lines = file($this->CONFIG_FILE, FILE_IGNORE_NEW_LINES);
			foreach ($lines as $lineNr => $line) {
				$logiLine = $lineNr - $offset;
				switch($logiLine) {
					case 0:
						$this->DB_HOST_URL = $line;
						break;
					case 1:
						$this->DB_NAME = $line;
						break;
					case 2:
						$this->DB_USERNAME = $line;
						break;
					case 3:
						$this->DB_PASSWORD = $line;
						break;
					case 4:
						if($line == "true") $this->RADIO_ACTIVE = true;
						else if($line == "false") $this->RADIO_ACTIVE = false;
						break;
					case 5:
						$this->RADIO_URL = $line;
						break;
					case 6:
						$this->LOGO_FOLDER = $line;
						break;
				}
			}
		}
	}
	
	function get_DB_HOST_URL() {
		return $this->DB_HOST_URL;
	}
	
	function get_DB_NAME() {
		return $this->DB_NAME;
	}
	
	function get_DB_USERNAME() {
		return $this->DB_USERNAME;
	}
	
	function get_DB_PASSWORD() {
		return $this->DB_PASSWORD;
	}

	function get_RADIO_ACTIVE() {
		return $this->RADIO_ACTIVE;
	}

	function get_RADIO_URL() {
		return $this->RADIO_URL;
	}

	function get_LOGO_FOLDER() {
		return $this->LOGO_FOLDER;
	}
}
?>
