<?php
/**
  * webradio station catalog, using mysql
  * 2020 Andreas Bahr 
  */


class webRadioCatalog {

	private $db = null;
		
	function __construct() {
		$this->db = new mysqliapi();
	}

	// it's in the name - full catalog
	function stationList1($mimetype, $clienttype) {
		$sql = "SELECT DISTINCT a.id, a.name, a.longName, d.name AS lang, c.name AS nation, a.website, a.logoFile ";
		$sql .= "FROM station a ";
		$sql .= "INNER JOIN stream b ON a.id = b.stationId ";
		$sql .= "LEFT JOIN iso639 d ON a.lang = d.id ";
		$sql .= "LEFT JOIN iso3166 c ON a.nation = c.id ";
		$sql .= "ORDER BY a.name ASC";
		return $this->db->query($sql);
	}

	// it's in the name - with matching mimetypes
	function stationList2($mimetype, $clienttype) {
		if($mimetype == "") {
			return $this->stationList1($mimetype, $clienttype);
		} else {
			$sql = "SELECT DISTINCT a.id, a.name, a.longName, d.name AS lang, c.name AS nation, a.website, a.logoFile ";
			$sql .= "FROM station a ";
			$sql .= "INNER JOIN stream b ON a.id = b.stationId ";
			$sql .= "LEFT JOIN iso639 d ON a.lang = d.id ";
			$sql .= "LEFT JOIN iso3166 c ON a.nation = c.id ";
			$sql .= "WHERE b.mimeType IN (".$this->formatMimeType($mimetype).")";
			$sql .= "ORDER BY a.name ASC";
			return $this->db->query($sql);
		}
	}
	
	// return a stations stream-data
	function tuneStation($id, $mimetype, $clienttype, $qualityFirst) {
		$sql = "SELECT * FROM stream ";
		$sql .= "WHERE stationId = ".$id." AND mimeType IN (".$this->formatMimeType($mimetype).")";
		$sql .= "ORDER BY qualityBR";
		if($qualityFirst) {$sql .= " ASC";}
		else  {$sql .= " DESC";}
		return $this->db->query($sql);
	}

	// it's in the name - sql syntax
	function formatMimeType($mimetype) {
		if($mimetype == "") {
			$allMTString .= "'audio/mpeg'";
		} else {
			$allMTString = "";
			$allMT = explode("-", $mimetype);
			foreach($allMT as $oneMT) {
				if($allMTString != "") $allMTString .= ", ";
				$allMTString .= "'".$oneMT."'";
			}
		}
		return $allMTString;
	}
}
?>
