<?php
/**
  * the editor's view classes
  * 2020 Andreas Bahr 
  */


/* domain: webradio station */
class viewStation {

	private $model = null;
		
	function __construct() {
		$this->model = new modelStation();
	}

	function list() {
		$arrData = $this->model->list();
		$html = '<h3 style="margin-top: 25px;">Radio Station'."'".'s&nbsp;<button type="button" id="newStation" class="btn btn-default" title="Add station" onclick="javascript:action23();"><span class="glyphicon glyphicon-plus-sign"></span></button></h3><table class="table"><tbody>';
		foreach ($arrData as $value) {
			$html .= '<tr>';
			$html .= '<td width=80><img src="stationLogos/'.$value['logoFile'].'" alt="Station Logo" width=72></td>';
			$html .= '<td><h4><b>'.$this->nameFormula($value['name'], $value['longName']).'</b></h4>';
			$html .= $value['howManyStreams'].' stream(s)';
			if($value['website'] || $value['website'] != '') $html .= ' &bull; <a href="http://'.$value['website'].'" target="_blank">'.$value['website'].'</a>';
			$html .= '</td>';
			$html .= '<td width=70><button type="button" id="'.$value['id'].'" class="btn btn-lg btn-default pull-right" title="Edit station" onclick="javascript:action19('.$value['id'].');"><span class="glyphicon glyphicon-wrench"></span></button></td>';
			$html .= '</tr>';
		}
		$html .= '</tbody></table>';
		return $html;
	}

	function show($id) {
		$html = "";
		$arrData = $this->model->get($id);
		$html .= '<h3 style="margin-top: 25px">Station Data</h3>';
		$html .= '<p><table class="table"><tbody>';
		$html .= '<tr><td>ID:</td><td><b>'.$arrData[0]['id'].'</b></td></tr>';
		$html .= '<tr><td>Name / Long-Name:</td><td><b>'.$arrData[0]['name'].' / '.$arrData[0]['longName'].'</b></td></tr>';
		$html .= '<tr><td>Nation (ISO 3166):</td><td><b>'.$arrData[0]['nationText'].' ('.$arrData[0]['nation'].')</b></td></tr>';
		if($arrData[0]['website'] != '') $html .= '<tr><td>Website Url:</td><td><a href="http://'.$arrData[0]['website'].'" target="_blank"><b>'.$arrData[0]['website'].'</b></a></td></tr>';
		else $html .= '<tr><td>Website Url:</td><td>(No link Url)</td></tr>';
		if($arrData[0]['logoFile'] != '') $html .= '<tr><td>Logo File:</td><td><a href="stationLogos/'.$arrData[0]['logoFile'].'" target="_blank"><b>'.$arrData[0]['logoFile'].'</b></a>';
		else $html .= '<tr><td>Logo File:</td><td>(No file)';
		$html .= '&nbsp;<button type="button" class="btn btn-default" title="List Logo-Files" onclick="javascript:action65('.$id.');"><span class="glyphicon glyphicon-folder-open"></span></button></td></tr>';
		$html .= '<tr><td><code style="color: #0088cc;">Last edit:</code></td><td><code style="color: #0088cc;">'.$arrData[0]['editTS'].'h</code></td></tr>';
		$html .= '</tbody></table></p>';
		$html .= '<button type="button" class="btn btn-default" onclick="javascript:action0();"><b>Back</b></button>';
		$html .= '<button type="button" class="btn btn-default" onclick="javascript:action33('.$id.');" style="margin-left: 10px"><b>DELETE</b></button>';
		$html .= '<button type="button" class="btn btn-default" onclick="javascript:action57('.$id.');" style="margin-left: 10px"><b>Edit</b></button>';
		return $html;
	}

	function showEditor($id = 0) {
		$html = "";
		if($id == 0) $arrData = array();
		else $arrData = $this->model->get($id);

		if($id == 0) $title = 'New Station';
		else $title = 'Edit Station';
		$html .= '<h3 style="margin-top: 25px">'.$title.'</h3><p><form action="editor.php" method="post" class="form-horizontal" role="form">';
		$html .= '<input type="hidden" name="CMD" value="SAVE">';
		if($id != 0) $html .= '<input type="hidden" name="ID" value="'.$arrData[0]['id'].'">';
		
		$html .= '<div class="form-group"><label for="name" class="col-sm-3 control-label"><span class="pull-left">Short-Name *:</span></label>';
		$html .= '<div class="col-sm-9"><input type="text" name="name" value="'.$arrData[0]['name'].'" placeholder="..." class="form-control" maxlength="20" required></div></div>';
		$html .= '<div class="form-group"><label for="longName" class="col-sm-3 control-label"><span class="pull-left">Long-Name:</span></label>';
		$html .= '<div class="col-sm-9"><input type="text" name="longName" value="'.$arrData[0]['longName'].'" placeholder="..." class="form-control" maxlength="255"></div></div>';
		$html .= '<div class="form-group"><label for="nation" class="col-sm-3 control-label"><span class="pull-left">Nation:</span></label>';
		
		$html .= '<div class="col-sm-9"><select name="nation" class="form-control">';
		$selected = '';
		$arrNations = $this->model->listNations();
		foreach ($arrNations as $value) {
			if($value['id'] == $arrData[0]['nation']) $selected = ' selected';
			else $selected = '';
			$html .= '<option value="'.$value['id'].'"'.$selected.'>'.$value['name'].'</option>';
		}
		$html .= '</select></div></div>';
		
		$html .= '<div class="form-group"><label for="website" class="col-sm-3 control-label"><span class="pull-left">Website Domain:</span></label>';
		$html .= '<div class="col-sm-9"><input type="text" name="website" value="'.$arrData[0]['website'].'" placeholder="example.org" class="form-control" maxlength="255"></div></div>';
		$html .= '<div class="form-group"><div class="col-sm-offset-3 col-sm-9"><button type="button" class="btn btn-default" onclick="javascript:action0();"><b>Cancel</b></button>';
		$html .= '<button type="submit" class="btn btn-default" style="margin-left: 10px"><b>Save</b></button></div></div>';
		$html .= '</form></p>';
		return $html;
	}

	function nameFormula($name, $longName) {
		if($longName != '') return $longName;
		else return $name;
	}
}


/* domain: webradio stream */
class viewStream {

	private $model = null;
		
	function __construct() {
		$this->model = new modelStream();
	}

	function list($stationId) {
		$arrData = $this->model->list($stationId);
		$html = '<h4 style="margin-top: 25px">Stream Data&nbsp;<button type="button" id="newStream" class="btn btn-default" title="Add stream" onclick="javascript:action77('.$stationId.');"><span class="glyphicon glyphicon-plus-sign"></span></button></h4>';
		$html .= '<p><table class="table"><thead><tr><td width=40><b>ID</b></td><td width=100><b>Mime-Type</b></td><td width=40><b>Quality</b></td><td><b>Stream Url</b></td><td width=50></td><td width=50></td></tr></thead><tbody>';
		foreach ($arrData as $value) {
			$html .= '<tr>';
			$html .= '<td>'.$value['id'].'</td>';
			$html .= '<td>'.$value['mimeType'].'</td>';
			$html .= '<td><center>'.$value['qualityBR'].'</center></td>';
			$html .= '<td><a href="'.$value['streamUrl'].'" target="_blank">'.$value['streamUrl'].'</a></td>';
			$html .= '<td><button type="button" class="btn btn-default pull-right" title="Delete stream" onclick="javascript:action70('.$stationId.','.$value['id'].');"><span class="glyphicon glyphicon-remove-circle"></span></button></td>';
			$html .= '<td><button type="button" class="btn btn-default pull-right" title="Edit stream" onclick="javascript:action42('.$stationId.','.$value['id'].');"><span class="glyphicon glyphicon-wrench"></span></button></td>';
			$html .= '</tr>';
		}
		$html .= '</tbody></table>';
		return $html;
	}

	function showEditor($stationId, $id = 0) {
		$html = "";

		if($id == 0) $arrData = array();
		else $arrData = $this->model->get($id);
		if($id == 0) $title = 'New Stream';
		else $title = 'Edit Stream';
		$html .= '<h3 style="margin-top: 25px">'.$title.'</h3><p><form action="editor.php" method="post" class="form-horizontal" role="form">';
		$html .= '<input type="hidden" name="CMD" value="SAVE-STREAM">';
		if($stationId != 0) $html .= '<input type="hidden" name="STATIONID" value="'.$stationId.'">';
		else $html .= '<input type="hidden" name="STATIONID" value="'.$arrData[0]['stationId'].'">';
		if($id != 0) $html .= '<input type="hidden" name="ID" value="'.$arrData[0]['id'].'">';
		
		$html .= '<div class="form-group"><label for="mimeType" class="col-sm-3 control-label"><span class="pull-left">Mime-Type *:</span></label>';
		$html .= '<div class="col-sm-9"><select name="mimeType" class="form-control">';
		$selected = '';
		$arrMimeType = $this->model->listMimeType();
		foreach ($arrMimeType as $value) {
			if($value == $arrData[0]['mimeType']) $selected = ' selected';
			else $selected = '';
			$html .= '<option'.$selected.'>'.$value.'</option>';
		}
		$html .= '</select></div></div>';

		$html .= '<div class="form-group"><label for="qualityBR" class="col-sm-3 control-label"><span class="pull-left">Quality Class *:</span></label>';
		$html .= '<div class="col-sm-9"><select name="qualityBR" class="form-control">';
		$selected = '';
		$arrNations = $this->model->listQualityBR();
		foreach ($arrNations as $key => $value) {
			if($key == $arrData[0]['qualityBR']) $selected = ' selected';
			else $selected = '';
			$html .= '<option value="'.$key.'"'.$selected.'>'.$value.'</option>';
		}
		$html .= '</select></div></div>';

		$html .= '<div class="form-group"><label for="streamUrl" class="col-sm-3 control-label"><span class="pull-left">Stream Url *:</span></label>';
		$html .= '<div class="col-sm-9"><input type="url" name="streamUrl" value="'.$arrData[0]['streamUrl'].'" placeholder="http://..." class="form-control" maxlength="255"></div></div>';
		$html .= '<div class="form-group"><div class="col-sm-offset-3 col-sm-9"><button type="button" class="btn btn-default" onclick="javascript:action0();"><b>Cancel</b></button>';
		$html .= '<button type="submit" class="btn btn-default" style="margin-left: 10px"><b>Save</b></button></div></div>';
		$html .= '</form></p>';
		return $html;
	}
}


/* domain: files */
class viewFile {

	private $fs = null;

	function __construct($folder) {
		$this->fs = new filesFolders($folder);
	}

	function list($id) {
		$model = new modelStation();
		$station = $model->get($id);
		
		$html = '<h3 style="margin-top: 25px;">Logo Files&nbsp;<button type="button" id="newFile" class="btn btn-default" title="Add file" onclick="javascript:action25('.$id.');"><span class="glyphicon glyphicon-plus-sign"></span></button></h3>';
		$html .= '<form name="logoList" action="editor.php" method="post" role="form">';
		$html .= '<input type="hidden" name="CMD" value="CHOOSE-LOGO">';
		$html .= '<input type="hidden" name="ID" value="'.$id.'">';
		$html .= '<p><table class="table"><thead><tr><td width=70></td><td><b>Name</b></td><td width=100><b>Size</b></td><td width=100><b>Accessed</b></td><td width=100><b>Modified</b></td></thead><tbody>';
		$arrFiles = $this->fs->list();
		foreach($arrFiles as $files) {
			if($files[0] = 'f' && $files[2] != '.' && $files[2] != '..') {
				$html .= '<tr>';
				$html .= '<td><img src="stationLogos/'.$files[2].'" alt="Station Logo" width="64" /></td>';
				$html .= '<td>'.$files[2].'<br>';

				$checked = '';
				if($station[0]['logoFile'] == $files[2]) $checked = ' checked';
				$html .= '<input type="radio" name="FILENAME" value="'.$files[2].'"'.$checked.'></td>';

				$html .= '<td>'.$this->fs->nsizer($files[4], 1).'</td>';
				$html .= '<td>'.$files[5].'</td>';
				$html .= '<td>'.$files[6].'</td>';
				$html .= '</tr>';
			}
		}
		$checked = '';
		if($station[0]['logoFile'] == '' || $station[0]['logoFile'] == NULL) $checked = ' checked';
		$html .= '<tr><td></td><td><input type="radio" name="FILENAME" value="NO-LOGO-FILE"'.$checked.'>&nbsp;No Logo File</td><td></td><td></td><td></td></tr>';

		$html .= '</tbody></table></p>';
		$html .= '<button type="button" class="btn btn-default" onclick="javascript:action49('.$id.');"><b>Back</b></button>';
		$html .= '<button type="submit" class="btn btn-default" style="margin-left: 10px"><b>Choose</b></button>';
		$html .= '</form>';
		return $html;
	}

	function uploadFile($id) {
		$html = '<h3 style="margin-top: 25px;">Upload File</h3>';
		$html .= '<p><form enctype="multipart/form-data" action="editor.php" method="POST" role="form">';
		$html .= '<input type="hidden" name="CMD" value="USERFILE">';
		$html .= '<input type="hidden" name="ID" value="'.$id.'">';
		$html .= '<input type="hidden" name="MAX_FILE_SIZE" value="1000000" />';
		$html .= '<input name="USERFILE" type="file" />';
		$html .= '<br />';
		$html .= '<button type="button" class="btn btn-default" onclick="javascript:action49('.$id.');"><b>Back</b></button>';
		$html .= '<button type="submit" class="btn btn-default" style="margin-left: 10px"><b>Upload</b></button>';
		$html .= '</form></p>';
		return $html;
	}
}


/* webradio tuner using html5-audio tag */
class viewTuner {

	private $model = null;
		
	function __construct() {
		$this->model = new modelStream();
	}

	function show($stationId, $streamId = 0) {
		$streamInfo = '';
		if($streamId == 0) $arrData = $this->model->list($stationId);
		else $arrData = $this->model->get($streamId);
		$html = '<audio controls preload="none">';
		$i = 0; $mimetype = '';
		foreach ($arrData as $value) {
			if($streamId == 0 || $streamId == $value['id']) {
				$html .= '<source src="'.$value['streamUrl'].'" type="'.$value['mimeType'].'">';
				$mimetype = $value['mimeType'];
				$i++;
			}
		}
		$html .= '<p>This browser does not support the <code>audio</code> element</p></audio>';
		if($i == 1) $html .= '<p>1 '.$mimetype.'-stream</p>';
		else $html .= '<p>'.$i.' stream(s)</p>';
		return $html;
	}
}
?>
