/**
  * JS toolbox
  * 2020 Andreas Bahr
  */

/** show station list */
function action0() {
	window.location.href = "editor.php?CMD=LIST";
}

/** show station XY */
function action19(id) {
	window.location.href = "editor.php?CMD=SHOW&ID=" + id;
}

/** new station */
function action23(id) {
	window.location.href = "editor.php?CMD=NEW";
}

/** add logo file */
function action25(id) {
	window.location.href = "editor.php?CMD=UPLOAD&ID=" + id;
}

/** delete station */
function action33(id) {
	if(window.confirm("Delete station & stream data?")) window.location.href = "editor.php?CMD=DELETE&ID=" + id;
}

/** edit stream */
function action42(stationId, id) {
	window.location.href = "editor.php?CMD=EDIT-STREAM&STATIONID=" + stationId + "&ID=" + id;
}

/** back from logo-list */
function action49(id) {
	window.location.href = "editor.php?CMD=SHOW&ID=" + id;
}

/** edit station */
function action57(id) {
	window.location.href = "editor.php?CMD=EDIT&ID=" + id;
}

/** list logos */
function action65(id) {
	window.location.href = "editor.php?CMD=LIST-LOGO&ID=" + id;
}

/** delete stream */
function action70(stationId, id) {
	if(window.confirm("Delete stream data?")) window.location.href = "editor.php?CMD=DELETE-STREAM&STATIONID=" + stationId + "&ID=" + id;
}

/** new stream */
function action77(id) {
	window.location.href = "editor.php?CMD=NEW-STREAM&ID=" + id;
}

/** ahow audio capabilities */
function action99() {
	$("#audioCapsDisplay").html("<center><pre>" + checkAudioTXT() + "</pre></center>");	
}

/** report audio capabilities */
function checkAudioTXT() {
	var audioCaps = "Browser Audio Capabilities\n--------------------------";
	var codecName, result;
	const queryMT = ['audio/mp4', 'audio/mpeg', 'audio/ogg', 'audio/opus', 'audio/wav', 'audio/x-ms-wma', 'audio/webm'];

	var checker = new Audio("");
	for(var i = 0; i <= 6; i++) {
		try {
			result = checker.canPlayType(queryMT[i]);
			if(audioCaps != "") audioCaps = audioCaps + "\n";
			codecName = queryMT[i].substring(6);
			audioCaps = audioCaps + codecName + ":";
			if(result == "") result = "no";
			for(var j = 25 - codecName.length - result.length; j != 0; j--) audioCaps = audioCaps + ".";
			audioCaps = audioCaps + result;
		} catch (e) {
			// NOP
		}
	}
	return audioCaps;
}
