<?php
   // simple webcam picture admin v0.1.4
  // 2012-2021 andreas bahr
 // ----------------------------------------
// fisherman-config:
$homedir = '/home/schwitt2/public_html/cam/cam-bot2';
$webdir = '../cam-bot2';
$scriptpath = 'admin';

// ssaft www-config:
/* $homedir = '/home/supersa1/werkstatt.supersaft.ch/cambot';
$webdir = '../cambot';
$scriptpath = 'admin'; */

// dev-zone-config:
/* $homedir = '/home/andi/dev/FishEYEviewer/ww3/pixes';
$webdir = '../pixes';
$scriptpath = 'admin'; */

// php error reporting
ini_set("display_errors", "1");
error_reporting(E_ERROR);
//error_reporting(E_ERROR | E_WARNING | E_PARSE);

// params
$cmd = isset($_REQUEST['cmd']) ? $_REQUEST['cmd'] : '';
$cd = isset($_REQUEST['cd']) ? $_REQUEST['cd'] : '';
$workfile = isset($_REQUEST['filename']) ? $_REQUEST['filename'] : '';

// actions
$errorMsg = '';
switch($cmd) {
	case "home":
		$cd = '';
		$workdir = $homedir;
		break;
	case "up":
		$cd = dir_up($cd);
		if($cd != '/') $workdir = $homedir.$cd;
		else $workdir = $homedir;
		break;
	case "delete":
		$workdir = $homedir.$cd;
		if(!unlink($workdir.DIRECTORY_SEPARATOR.$workfile)) $errorMsg = 'Fehler: Datei '.$workfile.' konnte nicht gelöscht werden';
		break;
	case "deletemany":
		$workdir = $homedir.$cd;
		$delfile = '';
		foreach($_POST as $cbname => $cbvalue) {
			if(substr($cbname, 0, 8) == 'checkbox') {
				$delfile = str_replace('_', '.', substr($cbname, 8));
				if($cbvalue == 'on') {
					if(!unlink($workdir.DIRECTORY_SEPARATOR.$delfile)) $errorMsg .= 'Fehler: Datei '.$delfile.' konnte nicht gelöscht werden - ';
				}
			}
		}
		break;
	default:
		// goto
		$workdir = $homedir.$cd;
}

// scan dir
$starray = array();
$dirray = scandir($workdir);
// PHP 5.3: $finfo = new finfo(FILEINFO_MIME, $mimemagicdb);
foreach($dirray AS $file) {
	$skip = false;
	switch($file) {
		case ".":
		case "..":
			$ford = "d";
			break;
		default:
			if(is_dir($workdir.DIRECTORY_SEPARATOR.$file)) $ford = "d";
			elseif(str_starts_with2($file, '.')) $skip = true;
			else $ford = "f";
	}
	if(!$skip) {
		$statinfo = stat($workdir.DIRECTORY_SEPARATOR.$file);
		if($ford == "f") {
			$fsize = $statinfo["size"];
			$mimetype = mime_content_type($workdir.DIRECTORY_SEPARATOR.$file);
		} else {
			$fsize = 0;
			$mimetype = "&nbsp;";
		}
		$userinfo = posix_getpwuid($statinfo["uid"]);
		$groupinfo = posix_getgrgid($statinfo["gid"]);
		$atime = date("d.m.Y", $statinfo["atime"]);
		$mtime = date("d.m.Y", $statinfo["mtime"]);
		$starray[] = array($ford, $workdir, $file, $mimetype, $fsize, $atime, $mtime, $userinfo["name"], $groupinfo["name"]);
	}
}

// navigate file path one level up 
function dir_up ($dirpath) {
	if($dirpath == '/') return '';
	$dirpath = format_folderpath($dirpath);
	for($i = strlen($dirpath) - 2; $i >= 0; $i--) {
		if($dirpath[$i] == DIRECTORY_SEPARATOR) {
			$dirpath = substr($dirpath, 0, $i);
			break;
		}
	}
	//if($dirpath == '') return '/';
	return $dirpath;
}

// filepath string formating
function format_folderpath($folderpath) {
	if(substr($folderpath, -1, 1) == DIRECTORY_SEPARATOR) {
		$folderpath = substr($folderpath, 0, strlen($folderpath) - 1);
	}
	return $folderpath;
}

// number scaling
function nsizer($value, $ddigits = 0, $sign = "B") {
  if($value >= 1099511627776) $ret = sprintf("%.".$ddigits."f"." T".$sign, $value / 1099511627776);
  elseif($value >= 1073741824) $ret = sprintf("%.".$ddigits."f"." G".$sign, $value / 1073741824);
  elseif($value >= 1048576) $ret = sprintf("%.".$ddigits."f"." M".$sign, $value / 1048576);
  elseif($value >= 1024) $ret = sprintf("%.".$ddigits."f"." K".$sign, $value / 1024);
  else $ret = $value." ".$sign;
  return $ret;
}

// replacement fx
function str_starts_with2($schnur, $zeichen) {
	if(stripos($schnur, $zeichen) === 0) return true;
	else return false;
}
?>
<html>
<head>
</head>
<body>
	<style>
		a:link, a:visited, a:active, a:hover {
			color: #375f7e;
		}
		a.linkbutton:link, a.linkbutton:visited {
			color: #ffffff;
			background-color: #375f7e;
			font-size: 14px;
			font-family: Verdana, sans-serif;
			font-weight: normal;
			text-decoration: none;
			padding-top: 6px;
			padding-right: 6px;
			padding-bottom: 4px;
			padding-left: 6px;
			border: 0px;
		}
		a.linkbutton:active, a.linkbutton:hover {
			color: #18212a;
			background-color: #c0c0c0;
			font-size: 14px;
			font-family: Verdana, sans-serif;
			font-weight: normal;
			text-decoration: none;
			padding-top: 6px;
			padding-right: 6px;
			padding-bottom: 4px;
			padding-left: 6px;
			border: 0px;
		}

		.deadbutton {
			color: #18212a;
			background-color: #c0c0c0;
			font-size: 14px;
			font-family: Verdana, sans-serif;
			font-weight: normal;
			text-decoration: none;
			padding-top: 6px;
			padding-right: 6px;
			padding-bottom: 4px;
			padding-left: 6px;
			border: 0px;
		}

		body {
			color: #18212a;
			font-family: Verdana, sans-serif;
			font-size: 14px;
			background-color:#ffffff;
			line-height:1.4em;
			text-align: left;
			margin: 0px;
			padding: 0px;
		}
		h1 {
			color: #375f7e;
			font-size: 22px;
			font-family: Verdana, sans-serif;
			padding-top: 12px;
			font-weight: normal;
			font-style: normal;
		}
		h2 {
			color: #18212a;
			font-size: 16px;
			font-family: Verdana, sans-serif;
			font-weight: normal;
			font-style: normal;
		}
		img {
			font-size: 12px;
			font-family: Verdana, sans-serif;
			font-weight: normal;
			font-style: normal;
			border: 0
		}
		p {
			color: #18212a;
			font-size: 14px;
			font-family: Verdana, sans-serif;
			line-height: 14px;
			line-height: 1.4em;
		}
		td {
			color: #18212a;
			font-family: Verdana, sans-serif;
			font-size: 14px;
		}

		div.main {
			font-size: 14px;
			font-family: Verdana, sans-serif;
			font-weight: normal;
			text-decoration: none;
			padding-top: 20px;
			padding-right: 20px;
			padding-bottom: 20px;
			padding-left: 20px;
		}

		table.standard {
			border:2px solid #c0c0c0;
		}
		tr.standardheader, td.standardheader {
			color: #18212a;
			background-color:#c0c0c0;
		}

		.bold {
			font-weight: bold;
		}

		.red {
			color: #ff0020;
		}

		tr.listeven {
			background-color: #e0e0e0;
		}
		tr.listodd {
			background-color: #e9e9e9;
		}
	</style>
	<script>
		function changedir(foldername) {
			document.thefolder.cd.value = foldername;
			document.thefolder.cmd.value = 'goto';
			document.thefolder.submit();
		}
		function deletefile(filename) {
			if(window.confirm("Sicher?")) {
				document.thefolder.filename.value = filename;
				document.thefolder.cmd.value = 'delete';
				document.thefolder.submit();
			}
		}
		function deletemanyfiles() {
			if(window.confirm("Sicher?")) {
				document.thefolder.cmd.value = 'deletemany';
				document.thefolder.submit();
			}
		}
	</script>

	<div class="main">
		<h1>Webcam Dateien</h1>
		<h2><?= $homedir ?></h2>
		<?php
		if($errorMsg != '') {
			?><p class="red"><?= $errorMsg ?></p><?php
		}
		?>

		<form name="thefolder" action="" method="POST">
			<p>
				<input type="text" name="cd" value="<?= $cd ?>" style="width: 420px">
    			&nbsp;
				<a href="javascript: document.thefolder.cmd.value = 'goto'; document.thefolder.submit();" class="linkbutton">&nbsp;Goto&nbsp;</a>
				<!-- &nbsp;
				<a href="javascript: document.thefolder.cmd.value = 'up'; document.thefolder.submit();" class="<?php // = ($cd != '') ? 'linkbutton' : 'deadbutton' ?>">&nbsp;up&nbsp;</a>
				-->
				&nbsp;
				<a href="javascript: document.thefolder.cmd.value = 'home'; document.thefolder.submit();" class="<?= ($workdir != $homedir) ? 'linkbutton' : 'deadbutton' ?>">&nbsp;Home&nbsp;</a>
			</p>

			<table class="standard">
				<tr class="standardheader">
					<td width="30">&nbsp;</td>
					<td width="230">Name</td>
					<td width="130" align="center">Typ</td>
					<td width="80" align="center">Gr&ouml;sse</td>
					<td width="90" align="center">Verwendung</td>
					<td width="90" align="center">Datum</td>
					<td width="90" align="center">&nbsp;</td>
					<td width="60" align="center">Auswahl</td>
				</tr>
				<?php
				$i = 0; $cntFiles = 0;
				foreach($starray AS $file) {
					if($file[2] != '.' AND $file[2] != '..') {
						?>
						<tr class="<?= (($i++)%2) ? 'listeven' : 'listodd'; ?>">
							<td align="center">
								<?php
								if($file[0] == 'd') {
									?><a href="javascript: changedir('<?= $cd.DIRECTORY_SEPARATOR.$file[2] ?>');"><img src="data:image/png;base64,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" width="150" border="0" alt="Verzeichnis"></a><?php
								} else {
									if(strlen($cd) > 0) $basefolder = $webdir.$cd.DIRECTORY_SEPARATOR;
									else $basefolder = $webdir.DIRECTORY_SEPARATOR;
									?><img src="<?= $basefolder.$file[2] ?>" width="150" border="0" alt="Bild"><?php
								}
								?>
							</td>
							<td>
								<?php
								if($file[0] == 'd') {
									?><a href="javascript: changedir('<?= $cd.DIRECTORY_SEPARATOR.$file[2] ?>');"><?= $file[2] ?></a><?php
								} else {
									echo $file[2];
									$cntFiles++;
								}
								?>
							</td>
							<td align="center"><?= ($file[0] == 'f') ? $file[3] : 'Verzeichnis' ; ?></td>
							<td align="right"><?= ($file[0] == 'f') ? nsizer($file[4], 1, 'B') : '' ; ?></td>
							<td align="center"><?= $file[5] ?></td>
							<td align="center"><?= $file[6] ?></td>
							<td align="center">
								<?php
								if($file[0] == 'f') {
									?><a href="javascript: deletefile('<?= $file[2]; ?>');" class="linkbutton">&nbsp;L&ouml;schen&nbsp;</a><?php
								}
								?>
							</td>
							<td align="center">
								<?php
								if($file[0] == 'f') { ?>
									<input type="checkbox" name="checkbox<?= $file[2] ?>" value="on">
								<?php } ?>
						</tr>
					<?php
					} 
				}
				if($cntFiles > 0) {
					?>
					<tr>
						<td colspan="8" style="text-align: right; height: 35px;"><a href="javascript: deletemanyfiles();" class="linkbutton">&nbsp;Alle ausgew&auml;hlten Dateien l&ouml;schen&nbsp;</a></td>
					</tr>
				<?php } ?>
			</table>
			<input type="hidden" name="cmd" value="">
			<input type="hidden" name="filename" value="">
		</form>
	</div>

</body>
</form>
