<?php
/** daumenkino v0.6.1
  * 2021 Andreas Bahr
  * license: GPL3
  * -------------
  * test drive:
  * run this cmd in the scripts folder: php -S localhost:8000
  */
  

// php error reporting
//ini_set("display_errors", "1");
//error_reporting(E_ERROR | E_WARNING | E_PARSE);

// picture-folder to scan
$scanBaseFolder = 'pixes';

class filesFolders {
	private $basePath = '';
	
	function __construct($basePath = '') {
		if($basePath != '') $this->basePath = $basePath;
	}

	/* scan a folder
	 * -------------
	 * array column's:
	 * 0: f=file, d=folder
	 * 1: path
	 * 2: name
	 * 3: mime-type
	 * 4: bytes
	 */
	function list($path = '') {
		if($path == '') $path = $this->basePath;
		$starray = array();
		$dirray = scandir($path);
		// PHP 5.3: $finfo = new finfo(FILEINFO_MIME, $mimemagicdb);
		foreach($dirray AS $file) {
			switch($file) {
				case ".":
				case "..":
					$ford = "d";
					break;
				default:
					if(is_dir($path.DIRECTORY_SEPARATOR.$file)) $ford = "d";
					else $ford = "f";
			}
			$statinfo = stat($path.DIRECTORY_SEPARATOR.$file);
			if($ford == "f") {
				$fsize = $statinfo["size"];
				$mimetype = mime_content_type($path.DIRECTORY_SEPARATOR.$file);
			} else {
				$fsize = 0;
				$mimetype = "";
			}
			$starray[] = array($ford, $path, $file, $mimetype, $fsize);
		}
		return $starray;
	}
}

// query images
$pixData = array();
$lastPix = ''; $pixEmpty = ''; $pixHtml = ''; $pixCount = 0;
$fs1 = new filesFolders($scanBaseFolder);
$folders = $fs1->list();
foreach($folders as $folder) {
	if($folder[0] == 'd' and $folder[2] != '.' and $folder[2] != '..') {
		$fs2 = new filesFolders($scanBaseFolder.DIRECTORY_SEPARATOR.$folder[2]);
		$scanpix = $fs2->list();
		foreach($scanpix as $afile) {
			if($afile[3] == 'image/jpeg') {
				$lastPix = $afile[1].'/'.$afile[2];
				$pixData[] = $afile[1].'/'.$afile[2];
				$pixCount += 1;
			}
		}
	} else if($folder[0] == 'f' and $folder[2] == "empty.jpg") {
		$pixEmpty = $scanBaseFolder.DIRECTORY_SEPARATOR.$folder[2];
	}
}
?><!DOCTYPE html>
<html lang="de">
<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="robots" content="index">
	<title>Werkstatt Schaufenster</title>
	<link rel="stylesheet" href="jquery/jquery-ui.css">
</head>
<body>
	<style>
		body {font-family: Helvetica,Arial,"Nimbus Sans L",sans-serif;}
		
		/* button design: Federico Dossena */ 
		a.button1 {
			display:inline-block;
			padding:0.35em 1.2em;
			border:0.1em solid #000000;
			margin:0 0.3em 0.3em 0;
			border-radius:0.12em;
			box-sizing: border-box;
			text-decoration:none;
			/* font-family:'Roboto',sans-serif; */
			font-weight:300;
			color:#000000;
			text-align:center;
			transition: all 0.2s;
		}
		a.button1:hover {
			color:#FFFFFF;
			background-color:#000000;
		}
		@media all and (max-width:30em) {
			a.button1 {
				display:block;
				margin:0.4em auto;
			}
		}
		
		/* jquery slider */
		.ui-draggable, .ui-droppable {background-position: top;}
	</style>
	
	<center>
		<h2>Werkstatt Schaufenster</h2>
		<div class="pixkino" data-pixkino-state="" data-pixkino-interval="500">
			<canvas id="pk-canvas" width="640" height="480"></canvas>
		</div>
		<?php
		if($pixCount >= 2) {
			?>
			<div id="slider" style="margin-top: 7px;width: 500px"></div>
			<div style="margin-top: 12px;">
				<a href="javascript:pixkino2.previous();" class="button1">&lt;</a>
				<a href="javascript:pixkino2.start();" class="button1">Play</a>
				<a href="javascript:pixkino2.stop();" class="button1">Pause</a>
				<a href="javascript:pixkino2.next();" class="button1">&gt;</a>
			</div>
			<?php
		}
		?>
		<div style="margin-top: 10px;">
			<span id="pixkino-page"></span>
		</div>
		
	</center>

	<script src="jquery/jquery-1.12.4.js"></script>
	<script src="jquery/jquery-ui-1.12.1.js"></script>
	<script>
		/** play timelapse movie */
		var pixEmpty = "<?php echo($pixEmpty); ?>";
		var pixLast = "<?php echo($lastPix); ?>";
		var pixCount = <?php echo(count($pixData)); ?>;
		var pixData = <?php echo(json_encode($pixData)); ?>;
		var pixkino2 = {
			timerHandle: 0,
			cursor: 0,
			firstRun: true,

			init: function() {
				// setup slider
				$("#slider").slider({
					value: pixCount - 1,
					min: 0,
					max: pixCount - 1,
					step: 1,
					slide: function(event, ui) {
						pixkino2.directDraw(ui.value);
					}
				});
				
				// load initial pix
				if(pixCount >= 1 && pixLast != "") {
					pixkino2.loadPix(pixLast);
				} else if(pixEmpty != '') {
					pixkino2.loadPix(pixEmpty);
				}
			},

			loadPix: function(fileName) {
				var ctx = document.getElementById('pk-canvas').getContext('2d');
				var nextImage = new Image();
				nextImage.addEventListener('load', function() {
					ctx.drawImage(nextImage, 0, 0);
				}, false);
				nextImage.src = fileName;
			},

			start: function() {
				if($(".pixkino").attr("data-pixkino-state") != "run") {
				  $(".pixkino").attr("data-pixkino-state", "run");
				  pixkino2.ticks();
				  msecs = Number($(".pixkino").attr("data-pixkino-interval"));
				  pixkino2.timerHandle = window.setInterval(pixkino2.ticks, msecs);
				}
			},

			stop: function() {
				$(".pixkino").attr("data-pixkino-state", "");
				clearInterval(pixkino2.timerHandle);
			},

			previous: function() {
				pixkino2.stop();
				pixkino2.gear(false);
			},
			
			next: function() {
				pixkino2.stop();
				pixkino2.gear(true);
			},
			
			ticks: function() {
				if($(".pixkino").attr("data-pixkino-state") == "run") {
				  pixkino2.gear(true);
				}
			},

			gear: function(goForward) {
				bell = false;
				cursor = pixkino2.cursor;
				
				if(pixkino2.firstRun) {
				  if($(".pixkino").attr("data-pixkino-state") == "run") {
					next = 0;
				  } else {
					if(goForward) {
					  next = 0;
					} else {
					  next = pixCount - 2;
					}
				  }
				} else {
				  if(goForward) {
					if((cursor + 1) == (pixCount - 1)) {
					  bell = true;
					}
					next = cursor + 1;
				  } else {
					if((cursor - 1) < 0) {
					  next = 0;
					} else {
					  next = cursor - 1;
					}
				  }
				}

				// render pix, display info, update slider
				pixkino2.loadPix(pixData[next]);
				$("#pixkino-page").text(String(next + 1) + " / " + String(pixCount));
				$("#slider").slider({value: next});

				pixkino2.cursor = next;
				pixkino2.firstRun = false;
				if(bell) {
				  pixkino2.eofs();
				}
			},
			
			eofs: function() {
				pixkino2.stop();
				pixkino2.firstRun = true;
			},
			
			directDraw: function(next) {
				pixkino2.stop();

				// load pix, display info
				pixkino2.loadPix(pixData[next]);
				$("#pixkino-page").text(String(next + 1) + " / " + String(pixCount));

				pixkino2.cursor = next;
				pixkino2.firstRun = false;
			},
		}
		
		$(function() {
			pixkino2.init();
			
			// autostart
			pixkino2.start();
		});
	</script>
</body>
</html>
