<?php
/** daumenkino v0.7.9
  * 2021-2022 Andreas Bahr
  * license: GPL3
  * -------------
  * test drive:
  * run this cmd in the scripts folder: php -S localhost:8000
  */
  

class FilesFolders {
	private $basePath = '';
	
	function __construct($basePath = '') {
		if($basePath != '') $this->basePath = $basePath;
	}

	/* scan a folder
	 * -------------
	 * array column's:
	 * 0: f=file, d=folder
	 * 1: path
	 * 2: name
	 * 3: mime-type
	 * 4: bytes
	 */
	function list($path = '') {
		if($path == '') $path = $this->basePath;
		$starray = array();
		$dirray = scandir($path);
		// PHP 5.3: $finfo = new finfo(FILEINFO_MIME, $mimemagicdb);
		foreach($dirray AS $file) {
			switch($file) {
				case ".":
				case "..":
					$ford = "d";
					break;
				default:
					if(is_dir($path.DIRECTORY_SEPARATOR.$file)) $ford = "d";
					else $ford = "f";
			}
			$statinfo = stat($path.DIRECTORY_SEPARATOR.$file);
			if($ford == "f") {
				$fsize = $statinfo["size"];
				$mimetype = mime_content_type($path.DIRECTORY_SEPARATOR.$file);
			} else {
				$fsize = 0;
				$mimetype = "";
			}
			$starray[] = array($ford, $path, $file, $mimetype, $fsize);
		}
		return $starray;
	}
}

class PixelIndexer {
	public $pagesActive = false;
	public $pixPages = 0;
	public $pagePoint = 0;
	public $pageData = array();
	
	function forwardPager($data, $foldersMax, $page = 0) {
		$pdata = array();
		
		$howMuch = count($data);
		if($howMuch > $foldersMax) {
			$j = 0; $jPage = 0;
			$firstLoop = true;
			for($i = 0; $i < $howMuch; $i++) {
				$sample = $data[$i];
				if($sample[0] == 'd' and $sample[2] != '.' and $sample[2] != '..') {
					if($jPage == $page) {
						$pdata[] = $sample;
					}

					$j++;
					if($j > ($foldersMax - 1)) {
						$j = 0;
						$this->pageData[] = array(strval($jPage), 'Seite '.strval($jPage + 1));
						$jPage++;
					}
				} else {
					$pdata[] = $data[$i];
				}
			}
			$this->pagerCommon($page, $j, $jPage);
			return $pdata;
		} else {
			return $data;
		}
	}
	
	function reversePager($data, $foldersMax, $page = 0) {
		$pdata = array();
		
		$howMuch = count($data);
		if($howMuch > $foldersMax) {
			$j = 0; $jPage = 0;
			for($i = $howMuch - 1; $i >= 0; $i--) {
				$sample = $data[$i];
				if($sample[0] == 'd' and $sample[2] != '.' and $sample[2] != '..') {
					if($jPage == $page) {
						$pdata[] = $sample;
					}

					$j++;
					if($j > ($foldersMax - 1)) {
						$j = 0;
						$this->pageData[] = array(strval($jPage), 'Seite '.strval($jPage + 1));
						$jPage++;
					}
				} else {
					$pdata[] = $data[$i];
				}
			}
			$this->pagerCommon($page, $j, $jPage);
			return $pdata;
		} else {
			return $data;
		}
	}
	
	function pagerCommon($page, $j, $jPage) {
		if(count($this->pageData) == 0) {
			$this->pageData[] = array('0', 'Alle');
		} else if($j != 0) {
			$this->pageData[] = array(strval($jPage), 'Seite '.strval($jPage + 1));
			$this->pagesActive = true;
		} else {
			$this->pagesActive = true;
		}
		$this->pixPages = $jPage + 1;
		$this->pagePoint = $page;
	}
	
	function htmlOptionRender($page = 0) {
		$strHtml = '';
		
		if(count($this->pageData) > 0) {
			$i = 0;
			foreach($this->pageData as $pageOption) {
				if($i == $page) $temp = ' selected';
				else $temp = '';
				$strHtml .= '<option value="'.$pageOption[0].'"'.$temp.'>'.$pageOption[1].'</option>';
				$i++;
			}
		}
		return $strHtml;
	}
	
	function htmlLinkRender($page = 0) {
		$strHtml = '';
		
		if(count($this->pageData) > 0) {
			$strHtml = 'Seite: ';
			$i = 0; $firstLoop = true;
			foreach($this->pageData as $pageOption) {
				if($i == $page) {
					if(!$firstLoop) $strHtml .= ', ';
					$strHtml .= strval($pageOption[0] + 1);
				} else {
					if(!$firstLoop) $strHtml .= ', ';
					$strHtml .= '<a href="./?page='.$pageOption[0].'"><b>'.($pageOption[0] + 1).'</b></a>';
				}
				$i++;
				$firstLoop = false;
			}
		}
		return $strHtml;
	}
}

class DaumenKino {
	private $scanBaseFolder; private $reverseOrder = true; private $foldersMax;
	public $pagePoint = 0; public $pagerVisible = 'visibility: hidden;'; public $pageSelectorOptions = ''; public $pageSelectorLinks = '';
	public $pixData = array();
	public $lastPix = ''; public $pixEmpty = ''; public $pixCount = 0;
	
	function __construct($scanBaseFolder = '', $reverseOrder = true, $foldersMax = 91) {
		$this->scanBaseFolder = $scanBaseFolder;
		$this->reverseOrder = $reverseOrder;
		$this->foldersMax = $foldersMax;
	}

	function main($pagePoint = 0) {
		// folder-scanner
		$fs1 = new FilesFolders($this->scanBaseFolder);
		$folders = $fs1->list();

		// pagination
		$pager = new PixelIndexer();
		if($this->reverseOrder) {
			$folders = $pager->reversePager($folders, $this->foldersMax, $pagePoint);
		} else {
			$folders = $pager->forwardPager($folders, $this->foldersMax, $pagePoint);
		}
		if($pager->pagesActive) {
			$this->pageSelectorOptions = $pager->htmlOptionRender($pagePoint);
			$this->pageSelectorLinks = $pager->htmlLinkRender($pagePoint);
			$this->pagerVisible = 'visibility: visible;';
		}

		// image-indexer
		foreach($folders as $folder) {
			if($folder[0] == 'd' and $folder[2] != '.' and $folder[2] != '..') {
				$fs2 = new FilesFolders($this->scanBaseFolder.DIRECTORY_SEPARATOR.$folder[2]);
				$scanpix = $fs2->list();
				foreach($scanpix as $afile) {
					if($afile[3] == 'image/jpeg') {
						$this->lastPix = $afile[1].'/'.$afile[2];
						$this->pixData[] = $afile[1].'/'.$afile[2];
						$this->pixCount += 1;
					}
				}
			} else if($folder[0] == 'f' and $folder[2] == "empty.jpg") {
				$this->pixEmpty = $this->scanBaseFolder.DIRECTORY_SEPARATOR.$folder[2];
			}
		}

		// reverse order
		if($this->reverseOrder) {
			rsort($this->pixData);
			$this->reverseOrderString = '1';
		} else {
			$this->reverseOrderString = '0';
		}
		return true;
	}
}
