<?php
/** daumenkino template
  * 2021-2022 Andreas Bahr
  * license: GPL3
  * -------------
  * test drive:
  * run this cmd in the scripts folder: php -S localhost:8000
  */
  

// php error reporting
//ini_set("display_errors", "1");
//error_reporting(E_ERROR | E_WARNING | E_PARSE);

// load library
include 'daumenkino.php';

// configuration
$scanBaseFolder = 'pixes';
$reverseOrder = true;
$foldersMax = 91;
$pagePoint = 0;

// get parameter
if(isset($_GET['page'])) {
	$pagePoint = intval($_GET['page']);
}
// do the job
$dkino = new DaumenKino($scanBaseFolder, $reverseOrder, $foldersMax);
$dkino->main($pagePoint);
?><!DOCTYPE html>
<html lang="de">
<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="robots" content="index">
	<title>Werkstatt Schaufenster</title>
	<link rel="stylesheet" href="jquery/jquery-ui.css">
</head>
<body>
	<style>
		body {font-family: Helvetica,Arial,"Nimbus Sans L",sans-serif !important;}
		
		/* button design based on Federico Dossena's work */ 
		a.button1 {
			display:inline-block;
			padding:1.35em 2.2em;
			border:0.15em solid #000000;
			margin:0 0.3em 0.3em 0;
			border-radius:0.5em;
			box-sizing: border-box;
			text-decoration:none;
			/* font-family:'Roboto',sans-serif; */
			font-weight:300;
			color:#000000;
			text-align:center;
			transition: all 0.2s;
		}
		a.button1:hover {
			color:#FFFFFF;
			background-color:#000000;
		}
		@media all and (max-width:30em) {
			a.button1 {
				display:block;
				margin:0.4em auto;
			}
		}
		
		/* jquery slider */
		.ui-draggable, .ui-droppable {background-position: top;}
	</style>
	
	<center>
		<h2>Werkstatt Schaufenster</h2>
		<div class="pixkino" data-pixkino-state="" data-pixkino-interval="500">
			<canvas id="pk-canvas" width="640" height="480"></canvas>
		</div>
		<?php
		if($dkino->pixCount >= 2) {
			?>
			<div id="slider" style="margin-top: 7px; width: 500px"></div>
			<div style="margin-top: 12px;">
				<a href="javascript:pixkino2.previous();" class="button1">&lt;</a>
				<a href="javascript:pixkino2.start();" class="button1">Play</a>
				<a href="javascript:pixkino2.stop();" class="button1">Pause</a>
				<a href="javascript:pixkino2.next();" class="button1">&gt;</a>
			</div>
			<?php
		}
		?>
		<div style="margin-top: 10px; width: 400px;">
			<span id="pixkino-label" style="float: left;"></span>
			<span id="pixkino-spacer" style="float: left; margin-left: 20px; <?php echo($dkino->pagerVisible); ?>">
				<?php echo($dkino->pageSelectorLinks); ?>
			</span>
			<span id="pixkino-page" style="float: right;"></span>
		</div>
	</center>

	<script src="jquery/jquery-1.12.4.js"></script>
	<script src="jquery/jquery-ui-1.12.1.js"></script>
	<script src="pixkino2.js"></script>
	<script>
		/** play timelapse movie */
		var pixReverse = <?php echo($dkino->reverseOrderString); ?>;
		var pixEmpty = "<?php echo($dkino->pixEmpty); ?>";
		var pixLast = "<?php echo($dkino->lastPix); ?>";
		var pixCount = <?php echo(count($dkino->pixData)); ?>;
		var pixData = <?php echo(json_encode($dkino->pixData)); ?>;
		
		// main
		$(function() {
			pixkino2.init();
			
			// autostart
			//pixkino2.start();
		});
	</script>
</body>
</html>
