/**
 * pixkino
 * viewer-part of daumenkino php-script
 * 2021-22 Andreas Bahr
 * license: GPL3
 */

var pixkino2 = {
	timerHandle: 0,
	cursor: 0,
	firstRun: true,

	init: function() {
		var initPos = 0;
		if(pixReverse == 0) {
			initPos = pixCount - 1;
		}
		// setup slider
		$("#slider").slider({
			value: initPos,
			min: 0,
			max: pixCount - 1,
			step: 1,
			slide: function(event, ui) {
				pixkino2.directDraw(ui.value);
			}
		});
		
		// load initial pix
		if(pixCount >= 1 && pixLast != "") {
			pixkino2.loadPix(pixLast);
		} else if(pixEmpty != '') {
			pixkino2.loadPix(pixEmpty);
		}
	},

	loadPix: function(fileName) {
		var ctx = document.getElementById('pk-canvas').getContext('2d');
		var nextImage = new Image();
		nextImage.addEventListener('load', function() {
			// scale to fit?...
			ctx.drawImage(nextImage, 0, 0, 640, 480);
			//ctx.drawImage(nextImage, 0, 0);
		}, false);
		nextImage.src = fileName;
		pixkino2.loadLabel(fileName);
	},

	loadLabel: function(fileName) {
		var parts = fileName.split(".");
		var path = parts[0].split("/");
		var timeLabel = path[path.length - 1];
		var dateLabel = path[path.length - 2];
		
		var timeParts = timeLabel.split("-");
		var dateParts = dateLabel.split("-");
		$("#pixkino-label").html(dateParts[2] + "." + dateParts[1] + "." + dateParts[0] + " &bull; " + timeParts[0] + ":" + timeParts[1]);
	},

	start: function() {
		if($(".pixkino").attr("data-pixkino-state") != "run") {
		  $(".pixkino").attr("data-pixkino-state", "run");
		  pixkino2.ticks();
		  msecs = Number($(".pixkino").attr("data-pixkino-interval"));
		  pixkino2.timerHandle = window.setInterval(pixkino2.ticks, msecs);
		}
	},

	stop: function() {
		$(".pixkino").attr("data-pixkino-state", "");
		clearInterval(pixkino2.timerHandle);
	},

	previous: function() {
		pixkino2.stop();
		pixkino2.gear(false);
	},
	
	next: function() {
		pixkino2.stop();
		pixkino2.gear(true);
	},
	
	ticks: function() {
		if($(".pixkino").attr("data-pixkino-state") == "run") {
		  pixkino2.gear(true);
		}
	},

	gear: function(goForward) {
		bell = false;
		cursor = pixkino2.cursor;
		
		if(pixkino2.firstRun) {
		  if($(".pixkino").attr("data-pixkino-state") == "run") {
			next = 0;
		  } else {
			if(goForward) {
			  next = 0;
			} else {
			  next = pixCount - 2;
			}
		  }
		} else {
		  if(goForward) {
			if((cursor + 1) == (pixCount - 1)) {
			  bell = true;
			}
			next = cursor + 1;
		  } else {
			if((cursor - 1) < 0) {
			  next = 0;
			} else {
			  next = cursor - 1;
			}
		  }
		}

		// render pix, display info, update slider
		pixkino2.loadPix(pixData[next]);
		$("#pixkino-page").text(String(next + 1) + " / " + String(pixCount));
		$("#slider").slider({value: next});

		pixkino2.cursor = next;
		pixkino2.firstRun = false;
		if(bell) {
		  pixkino2.eofs();
		}
	},
	
	eofs: function() {
		pixkino2.stop();
		pixkino2.firstRun = true;
	},
	
	directDraw: function(next) {
		pixkino2.stop();

		// load pix, display info
		pixkino2.loadPix(pixData[next]);
		$("#pixkino-page").text(String(next + 1) + " / " + String(pixCount));

		pixkino2.cursor = next;
		pixkino2.firstRun = false;
	},
}
